#include <struct.h>
#include <3dengine.h>

#include "var.h"

//////////////////////////////////////
// Basement writing tools

WORD WriteWORD (CFile &f, WORD w)
{  f.Write(&w,2);  return 2;}
WORD WriteInt (CFile &f, int i)
{  f.Write(&i,2);  return 2;}
WORD WriteLong (CFile &f, long l)
{  f.Write(&l,4);  return 4;}
WORD WriteFloat (CFile &f, float v)
{  f.Write(&v,4);  return 4;}


long WriteObject(CFile* pFile, tObject* pObject, CDirect3D*  pD3D, CStringArray* pWarnings)
{
  WORD ID = EDIT_OBJECT;
  long size = 6;
  long sizemesh = 6;
  long count;
  int i;

  //--------- write Object;
  pFile->Write(&ID,2);
  pFile->Write(&size,4);//chunk size; we shall return here later;

  CString objname = CString(pObject->ObjectName);
  memset(temp_name, 0, 12);
  if (objname.GetLength() >= 11)
  {//trunc
    CString objname = CString(pObject->ObjectName);
    objname = objname.Left(10);
    for (i = 0; i < pWarnings->GetSize(); i++)
    {
      if (pWarnings->GetAt(i) == objname)
        objname = objname.Left(8)+Int2String(i);
    }
    strncpy(temp_name, objname, 10);
    size += 11;//10 chars and null terminator.
    pWarnings->Add(  CString("Object name ")+
          CString(pObject->ObjectName)+
          CString(" was truncatinated to ")+
          objname);
    pFile->Write(temp_name, 11);
  }//trunc
  else
  {
    size += objname.GetLength();
    strncpy(temp_name, objname, size-6);
    size++;//null terminator
    pFile->Write(temp_name, size-6);
  }

  ID = OBJ_TRIMESH;
  pFile->Write(&ID,2);
  pFile->Write(&sizemesh,4);//chunk size; we shall return here later;

  //calculate different vertices;
  pVertList = new VertexList;
  WORD* FaceMap = new WORD[pObject->FaceTable->FaceAmount*4];
  long Verts = 0;
  long pos;

  for ( count = 0; count < pObject->FaceTable->FaceAmount; count++)
  {//check and add cicle
    Vert3ds vert;
    vert.x = pObject->VertTable->Table[pObject->FaceTable->Table[count].I1].X;
    vert.y =-pObject->VertTable->Table[pObject->FaceTable->Table[count].I1].Z;
    vert.z = pObject->VertTable->Table[pObject->FaceTable->Table[count].I1].Y;
    vert.u = pObject->FaceTable->Table[count].U1;
    vert.v = 1.0f-pObject->FaceTable->Table[count].V1;
    pos = pVertList->Find(vert);
    if (pos == -1)
    {
      FaceMap[count*4] = (WORD)pVertList->Add(vert);
      Verts++;
    }
    else
      FaceMap[count*4] = (WORD)pos;

    vert.x = pObject->VertTable->Table[pObject->FaceTable->Table[count].I2].X;
    vert.y =-pObject->VertTable->Table[pObject->FaceTable->Table[count].I2].Z;
    vert.z = pObject->VertTable->Table[pObject->FaceTable->Table[count].I2].Y;
    vert.u = pObject->FaceTable->Table[count].U2;
    vert.v = 1.0f-pObject->FaceTable->Table[count].V2;
    pos = pVertList->Find(vert);
    if (pos == -1)
    {
      FaceMap[count*4+2] = (WORD)pVertList->Add(vert);
      Verts++;
    }
    else
      FaceMap[count*4+2] = (WORD)pos;
    vert.x = pObject->VertTable->Table[pObject->FaceTable->Table[count].I3].X;
    vert.y =-pObject->VertTable->Table[pObject->FaceTable->Table[count].I3].Z;
    vert.z = pObject->VertTable->Table[pObject->FaceTable->Table[count].I3].Y;
    vert.u = pObject->FaceTable->Table[count].U3;
    vert.v = 1.0f-pObject->FaceTable->Table[count].V3;
    pos = pVertList->Find(vert);
    if (pos == -1)
    {
      FaceMap[count*4+1] = (WORD)pVertList->Add(vert);
      Verts++;
    }
    else
      FaceMap[count*4+1] = (WORD)pos;

    FaceMap[count*4+3] = 0x15;//all visible+Mapping bit;
  }//check and add cicle

  ID = TRI_VERTEXL;
  pFile->Write(&ID,2);
  long vertssize = 8 + Verts*12; //2-ID, 4-size, 2-amount, 12 == sizeof(float)*3;
  pFile->Write(&vertssize,4);
  pFile->Write(&Verts,2);

  VertListNode* Ptr = pVertList->Head;
  for ( count = 0; ((count < Verts) && Ptr); count++)
  {
    pFile->Write(&Ptr->vert.x, 4);
    pFile->Write(&Ptr->vert.y, 4);
    pFile->Write(&Ptr->vert.z, 4);
    Ptr = Ptr->next;
  }
  sizemesh+=vertssize;

  ID = TRI_FACEUV;
  pFile->Write(&ID,2);
  long vertsuvsize = 8 + Verts*8;  //2-ID, 4-size, 2-amount, 8 == sizeof(float)*2;
  pFile->Write(&vertsuvsize,4);
  pFile->Write(&Verts,2);//amount of UVs

  Ptr = pVertList->Head;
  for ( count = 0; ((count < Verts) && Ptr); count++)
  {
    pFile->Write(&Ptr->vert.u, 4);
    pFile->Write(&Ptr->vert.v, 4);
    Ptr = Ptr->next;
  }
  sizemesh+=vertsuvsize;


  ID = TRI_FACEL1;
  pFile->Write(&ID,2);
  long facessize = 8 + pObject->FaceTable->FaceAmount*8;
  //2-ID, 4-size, 2-amount, 8 == sizeof(WORD)*4;(i1,i2,i3, type)
  pFile->Write(&facessize,4);
  pFile->Write(&pObject->FaceTable->FaceAmount,2);//amount of faces
  pFile->Write(FaceMap,pObject->FaceTable->FaceAmount*8);//faces
  sizemesh+=facessize;


  long facematsize = 0;
  for (i = 0; i < pD3D->Materials.MaterialsAmount; i++)
  {//write indexes for each material
    //count amount of faces of THAT material first;
    long amount = 0;
    for ( count = 0; count < pObject->FaceTable->FaceAmount; count++)
      if (pObject->FaceTable->Table[count].Material == i)
        amount++;
    if (amount > 0)
    {//write;
      ID = TRI_FACEMAT;
      pFile->Write(&ID,2);
      //CString name = pD3D->Materials.Materials[i].MaterialName;
      CString name = "Material#";
      name+=Int2String(i);
      name+='\0';
      facematsize = 6 + //ID, size;
        name.GetLength()
        + 2//amount
        + amount*2;//indexes

      pFile->Write(&facematsize, 4);

      BYTE ch;
      for (int j = 0; ((j==0) || (BYTE)name.GetAt(j-1)!=0); j++)
      {
        ch = name.GetAt(j);
        pFile->Write(&ch,1);
      }

      pFile->Write(&amount, 2);
      for ( count = 0; count < pObject->FaceTable->FaceAmount; count++)
        if (pObject->FaceTable->Table[count].Material == i)
          pFile->Write(&count, 2);
      facessize+=facematsize;
      sizemesh+=facematsize;
    }
  }//write indexes for each material

  ID = TRI_SMOOTH;
  pFile->Write(&ID,2);
  long smoothsize = 6 + pObject->FaceTable->FaceAmount*4;
  //2-ID, 4-size, 4 == sizeof(DWORD)
  pFile->Write(&smoothsize,4);
  DWORD smooth;
  for ( count = 0; count < pObject->FaceTable->FaceAmount; count++)
  {  
    smooth = pObject->FaceTable->Table[count].GetMiscFlag(0);
    if (smooth == 0) smooth = pObject->FaceTable->Table[count].Material+1;
    pFile->Write(&smooth, 4);
  }
  facessize+=smoothsize;
  sizemesh+=smoothsize;
  pFile->Seek(-facessize+2, CFile::current);
  pFile->Write(&facessize, 4);
  pFile->Seek(facessize-6, CFile::current);


  delete pVertList;
  delete[] FaceMap;

  size+=sizemesh;
  pFile->Seek(-sizemesh+2, CFile::current);
  pFile->Write(&sizemesh, 4);
  pFile->Seek(sizemesh-6, CFile::current);

  pFile->Seek(-size+2, CFile::current);
  pFile->Write(&size, 4);
  pFile->Seek(size-6, CFile::current);

  return size;
}



long WriteMaterial(CFile* pFile, D3DMAT* pMat, CDirect3D*  pD3D, CStringArray* pWarnings)
{
  WORD ID = EDIT_MATERIAL;
  long size = 6;
  long count;
  BYTE  rgb[3];
  WORD  amountof;

  pFile->Write(&ID,2);
  pFile->Write(&size,4);//chunk size; we shall return here later;
  /////write material here;

  //name
  Material mat3ds;
  ID = MAT_NAME01; pFile->Write(&ID,2);
  CString MatName = "Material#";
  MatName+=Int2String(NumMaterials);
  MatName+='\0';
  NumMaterials++;
  count = MatName.GetLength();
  strcpy(mat3ds.Name, MatName.GetBuffer(MatName.GetLength()));

  count+=6;
  pFile->Write(&count, 4);
  pFile->Write((char*)&mat3ds.Name, count-6);

  size+=count;

  //rgb
  ID = MAT_AMBIENT; pFile->Write(&ID,2);
  count = 15;size+=count;
  pFile->Write(&count, 4);//size
  ID = MAT_RGB1; pFile->Write(&ID,2);
  count = 9;
  pFile->Write(&count, 4);//size
  rgb[0] = (BYTE)(pMat->MatRec.ambient.r*255);
  rgb[1] = (BYTE)(pMat->MatRec.ambient.g*255);
  rgb[2] = (BYTE)(pMat->MatRec.ambient.b*255);
  pFile->Write(&rgb, 3);//size

  //rgb
  ID = MAT_DIFFUSE; pFile->Write(&ID,2);
  count = 15;size+=count;
  pFile->Write(&count, 4);//size
  ID = MAT_RGB1; pFile->Write(&ID,2);
  count = 9;
  pFile->Write(&count, 4);//size
  rgb[0] = (BYTE)(pMat->MatRec.diffuse.r*255);
  rgb[1] = (BYTE)(pMat->MatRec.diffuse.g*255);
  rgb[2] = (BYTE)(pMat->MatRec.diffuse.b*255);
  pFile->Write(&rgb, 3);//size

  //rgb
  ID = MAT_SPECULAR; pFile->Write(&ID,2);
  count = 15;size+=count;
  pFile->Write(&count, 4);//size
  ID = MAT_RGB1; pFile->Write(&ID,2);
  count = 9;
  pFile->Write(&count, 4);//size
  rgb[0] = (BYTE)(pMat->MatRec.specular.r*255);
  rgb[1] = (BYTE)(pMat->MatRec.specular.g*255);
  rgb[2] = (BYTE)(pMat->MatRec.specular.b*255);
  pFile->Write(&rgb, 3);//size

  //amount of
  ID = MAT_SHININESS; pFile->Write(&ID,2);
  count = 14;size+=count;
  pFile->Write(&count, 4);//size
  ID = MAT_MAPAMOUNT; pFile->Write(&ID,2);
  count = 8;
  pFile->Write(&count, 4);//size
  //amountof = (WORD)(pMat->MatParams.Shine*100);
  amountof = (WORD)100;//(pMat->MatRec.power);
  pFile->Write(&amountof, 2);

  //amount of
  ID = MAT_SHINSTEN; pFile->Write(&ID,2);
  count = 14;size+=count;
  pFile->Write(&count, 4);//size
  ID = MAT_MAPAMOUNT; pFile->Write(&ID,2);
  count = 8;
  pFile->Write(&count, 4);//size
  //amountof = (WORD)(pMat->MatRec.power);
  amountof = (WORD)100;//(pMat->MatParams.Shine*100);
  pFile->Write(&amountof, 2);

  //amount of
  ID = MAT_TRANSPAR; pFile->Write(&ID,2);
  count = 14;size+=count;
  pFile->Write(&count, 4);//size
  ID = MAT_MAPAMOUNT; pFile->Write(&ID,2);
  count = 8;
  pFile->Write(&count, 4);//size
  amountof = (WORD)((1.0f-pMat->MatRec.ambient.a)*100);
  pFile->Write(&amountof, 2);

  //amount of
  ID = MAT_TRANSFALL; pFile->Write(&ID,2);
  count = 14;size+=count;
  pFile->Write(&count, 4);//size
  ID = MAT_MAPAMOUNT; pFile->Write(&ID,2);
  count = 8;
  pFile->Write(&count, 4);//size
  amountof = 0;//Unsupported in Direct3D;
  pFile->Write(&amountof, 2);

  //amount of
  ID = MAT_REFLECT; pFile->Write(&ID,2);
  count = 14;size+=count;
  pFile->Write(&count, 4);//size
  ID = MAT_MAPAMOUNT; pFile->Write(&ID,2);
  count = 8;
  pFile->Write(&count, 4);//size
  if (pMat->MatParams.ReflTexture == -1)
    amountof = 0;//Unsupported
  else
    amountof = 50;//by default, set it to 50%
  pFile->Write(&amountof, 2);

  //amount of
  ID = MAT_TYPE; pFile->Write(&ID,2);
  count = 8;size+=count;
  pFile->Write(&count, 4);//size
  amountof = 3;//phong - by default;
  pFile->Write(&amountof, 2);

  //amount of
  ID = MAT_SELFILLUM; pFile->Write(&ID,2);
  count = 14;size+=count;
  pFile->Write(&count, 4);//size
  ID = MAT_MAPAMOUNT; pFile->Write(&ID,2);
  count = 8;
  pFile->Write(&count, 4);//size
  amountof = 0;//Unsupported
  pFile->Write(&amountof, 2);

  //EMPTY
  ID = 0xA08A; pFile->Write(&ID,2);
  count = 6; size+=count;
  pFile->Write(&count, 4);//size
  //EMPTY
  ID = 0xA08C; pFile->Write(&ID,2);
  count = 6; size+=count;
  pFile->Write(&count, 4);//size

  //amount of
  ID = 0xA087; pFile->Write(&ID,2);
  count = 10; size+=count;
  pFile->Write(&count, 4);//size
  float val = 1.0f;
  pFile->Write(&val, 4);

  //amount of
  ID = 0x0100; pFile->Write(&ID,2);
  count = 10; size+=count;
  pFile->Write(&count, 4);//size
  val = 1.0f;
  pFile->Write(&val, 4);

  if (pMat->MatParams.PrimTexture >= 0)
  {// textures
    ID = MAT_TXT1_MAP; pFile->Write(&ID,2);
    CString TexName = pD3D->Materials.Textures->GetName(pMat->MatParams.PrimTexture);
    //verify textures' name length;
    if (TexName.Find('.',1) > 8)
    {//truncatinating
      CString one, two;
      one = TexName.Left(8);
      two = TexName.Right(TexName.GetLength()-TexName.Find('.',1));
      TexName = one+two;
      pWarnings->Add(  CString("Texture name ")+
              TexName+
              CString(" was truncatinated to ")+
              one+two);
    }//truncatinating

    TexName+='\0';
    count = 6+ //id,size
        8+ //(0300, 8, 0):chunk
        6+TexName.GetLength()+ //0xA300 chunk
        8+//0xa351 chunk
        10;//0xa353 chunk
    size+=count;
    pFile->Write(&count, 4);//size
    ID = MAT_MAPAMOUNT; pFile->Write(&ID,2);
    count = 8;
    pFile->Write(&count, 4);//size
    amountof = 0x0064;//Unknown
    pFile->Write(&amountof, 2);
    ID = MAT_MAPFILE; pFile->Write(&ID,2);
    count = 6+TexName.GetLength();
    pFile->Write(&count, 4);//size
    pFile->Write(TexName.GetBuffer(TexName.GetLength()), TexName.GetLength());//filename
    ID = MAT_MAPOPT; pFile->Write(&ID,2);
    count = 8;
    amountof = 0;//no options
    pFile->Write(&count, 4);//size
    pFile->Write(&amountof, 2);
    ID = MAT_MAPFILTER; pFile->Write(&ID,2);
    count = 10;
    amountof = 0;//no filter
    pFile->Write(&count, 4);//size
    pFile->Write(&amountof, 4);
  }//texture
  if (pMat->MatParams.ReflTexture >= 0)
  {//refmap
    ID = MAT_REFL_MAP; pFile->Write(&ID,2);
    CString ReflName = pD3D->Materials.Textures->GetName(pMat->MatParams.ReflTexture);
    //verify textures' name length;
    if (ReflName.Find('.',1) > 8)
    {//truncatinating
      CString one1, two1;
      one1 = ReflName.Left(8);
      two1 = ReflName.Right(ReflName.GetLength()-ReflName.Find('.',1));
      ReflName = one1+two1;
      pWarnings->Add(  CString("Texture name ")+
              ReflName+
              CString(" was truncatinated to ")+
              one1+two1);
    }//truncatinating


    ReflName+='\0';
    count = 6+ //id,size
        8+ //(0300, 8, 0):chunk
        6+ReflName.GetLength();//0xA300 chunk
    size+=count;
    pFile->Write(&count, 4);//size
    ID = MAT_MAPAMOUNT; pFile->Write(&ID,2);
    count = 8;
    pFile->Write(&count, 4);//size
    amountof = 0x0064;//Unknown
    pFile->Write(&amountof, 2);
    ID = MAT_MAPFILE; pFile->Write(&ID,2);
    count = 6+ReflName.GetLength();
    pFile->Write(&count, 4);//size
    pFile->Write(ReflName.GetBuffer(ReflName.GetLength()), ReflName.GetLength());//filename
  }//refmap




  pFile->Seek(-size+2, CFile::current);
  pFile->Write(&size, 4);
  pFile->Seek(size-6, CFile::current);

  return size;
}




//////////////////////////////////////
DWORD CALLBACK Export(  CString Tofile,
            CWnd* pwnd,
            tObjectSet* Objects,
            tUnDataSet* UnData,
            CDirect3D*  d3d,
            SYSTEMREQUESTPROC RequestProc,
            HINSTANCE AppHIns,
            HINSTANCE DllHIns)
{
  CFile OutFile;
  if (!OutFile.Open(Tofile, CFile::modeWrite | CFile::modeCreate))
  {
    ShowFailMessage(pwnd, "Error rewriting file","Invalid Attributes?",MB_ICONEXCLAMATION);
    return 0;
  }
  
  CStringArray Warnings;
  
  WORD ID;
  long FileSize = 6;
  ID = MAIN3DS; OutFile.Write(&ID,2);//4D4D
  OutFile.Write(&FileSize,4);

  //Editor Version
  ID = EDIT_VERSION1; OutFile.Write(&ID,2);
  long tmp = 10; FileSize += tmp;
  OutFile.Write(&tmp, 4);//size
  tmp = 3;//version
  OutFile.Write(&tmp, 4);


  ID = EDIT3DS; OutFile.Write(&ID,2);//3D3D
  OutFile.Write(&FileSize,4);
  FileSize+=6;

  //Materials Version
  ID = EDIT_VERSION2; OutFile.Write(&ID,2);
  tmp = 10; FileSize+=tmp;
  OutFile.Write(&tmp, 4);//size
  tmp = 3;//version
  OutFile.Write(&tmp, 4);


  int i;
  NumMaterials = 0;
  for (i = 0; i < d3d->Materials.MaterialsAmount; i++)
    FileSize+=WriteMaterial(&OutFile, &d3d->Materials.Materials[i], d3d, &Warnings);

  for (i = 0; i < Objects->ObjAmount; i++)
    FileSize+=WriteObject(&OutFile, &Objects->ObjSet[i], d3d, &Warnings);


  //file size
  OutFile.Seek(-FileSize+2, CFile::current);
  OutFile.Write(&FileSize, 4);
  OutFile.Seek(FileSize-6, CFile::current);

  //edit3ds size
  FileSize-=16;
  OutFile.Seek(-FileSize+2, CFile::current);
  OutFile.Write(&FileSize, 4);
  OutFile.Seek(FileSize-6, CFile::current);

  OutFile.Close();

  
  if (Warnings.GetSize() > 0)
  {
    AfxSetResourceHandle(DllHIns);
    CWarnListDialog diag(IDD_EXPORTWARNINGSDIALOG, pwnd, &Warnings);
    diag.DoModal();
    Warnings.RemoveAll();
    AfxSetResourceHandle(AppHIns);
  }

  return 1;//OK
}